#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using BROKEN = gov.va.med.vbecs.Common.VbecsBrokenRules.Division;

#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_DivisionBase : BaseTest 
	{
		private DivisionBase _testReadyDivBase;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
			_testReadyDivBase = (DivisionBase)DivisionBase.GetBaseInfoForAllVbecsDivisions()[0];
		}

		[TearDown]
		protected void TearDown()
		{
			_testReadyDivBase = null;
		}

		[Test]
		public void GetBaseInfoForAllVbecsDivisions_Pass()
		{
			Assert.IsTrue( DivisionBase.GetBaseInfoForAllVbecsDivisions().Count > 0 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ParameterlessMethod)]
		public void GetBaseInfoForAllVbecsDivisions_Fail() {}

		[Test]
		public void AssociatedInstitutionsSet_Pass()
		{
			DataTable assocInstitutions = DAL.Division.GetAssociatedInstitutionsByDivision(_testReadyDivBase.DivisionCode);
			_testReadyDivBase.AssociatedInstitutions = assocInstitutions;
		
			Assert.AreEqual( assocInstitutions.Columns.Count, _testReadyDivBase.AssociatedInstitutions.Columns.Count );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void AssociatedInstitutionsSet_Fail()
		{
		}

		[Test]
		public void TimeZoneConfig_Pass()
		{
			TimeZoneConfig _tzc = new TimeZoneConfig();
			_tzc.TimeZone = new BOL.TimeZone( 'A' );

			_testReadyDivBase.TimeZoneConfig = _tzc;
			
			Assert.AreEqual( _tzc, _testReadyDivBase.TimeZoneConfig );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TimeZoneConfig_Fail()
		{
		}

		[Test]
		public void LabelPrinterConfig_Pass()
		{
			BOL.LabelPrinterConfig tstValue = new BOL.LabelPrinterConfig();

			this._testReadyDivBase.LabelPrinterConfig = tstValue;

			Assert.AreEqual(tstValue, this._testReadyDivBase.LabelPrinterConfig);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LabelPrinterConfig_Fail()
		{
		}

		[Test]
		public void UsesLabelPrinter_Pass()
		{
			_testReadyDivBase.UsesLabelPrinter = true;
			Assert.IsTrue( _testReadyDivBase.UsesLabelPrinter );

			_testReadyDivBase.UsesLabelPrinter = false;
			Assert.IsTrue( !_testReadyDivBase.UsesLabelPrinter );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions ) ]
		public void UsesLabelPrinter_Fail() {}

		[Test]
		public void IsActive_Pass()
		{
			_testReadyDivBase.IsActive = true;
			Assert.IsTrue( _testReadyDivBase.IsActive );

			_testReadyDivBase.IsActive = false;
			Assert.IsTrue( !_testReadyDivBase.IsActive );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions ) ]
		public void IsActive_Fail() {}

		[Test]
		public void LockInactivityTimeoutMin_Pass()
		{
			int tstValue = new Random().Next(BOL.DivisionBase.MinLockInactivityTimeoutMin, BOL.DivisionBase.MaxLockInactivityTimeoutMin);

			this._testReadyDivBase.LockInactivityTimeoutMin = tstValue;

			Assert.AreEqual(tstValue, this._testReadyDivBase.LockInactivityTimeoutMin);
		}

		[Test]
		public void LockInactivityTimeoutMin_Fail()
		{
			this._testReadyDivBase.SetInitialBrokenRules(BROKEN.FormClassName, BROKEN.RuleSets.BaseRuleSet);

			this._testReadyDivBase.LockInactivityTimeoutMin = BOL.DivisionBase.MaxLockInactivityTimeoutMin + 1;

			Assert.AreEqual(true, this._testReadyDivBase.IsRuleBroken(BROKEN.LockInactivityTimeoutInvalid), "BrokenRule");
		}


		[Test]
		public void PrinterName_Pass()
		{
			_testReadyDivBase.SetInitialBrokenRules(BROKEN.FormClassName, BROKEN.RuleSets.BaseRuleSet);
			_testReadyDivBase.PrinterName = "foo";
			Assert.AreEqual(false, _testReadyDivBase.IsRuleBroken(BROKEN.DefaultPrinterNotSet), "BrokenRule");
		}
		[Test]
		public void PrinterName_Fail()
		{
			_testReadyDivBase.SetInitialBrokenRules(BROKEN.FormClassName, BROKEN.RuleSets.BaseRuleSet);
			if (_testReadyDivBase.PrinterName != string.Empty)
			{
				_testReadyDivBase.PrinterName = string.Empty;
			}
			else
			{
				_testReadyDivBase.PrinterName = null;
			}
			Assert.AreEqual(true, _testReadyDivBase.IsRuleBroken(BROKEN.DefaultPrinterNotSet), "BrokenRule");
		}



		[Test]
		public void IsValid_Pass()
		{			
			BOL.DivisionBase tempDivBase = (DivisionBase)DivisionBase.GetBaseInfoForAllVbecsDivisions()[0];
			tempDivBase.SetInitialBrokenRules( "Division", "BaseRuleSet", true );
			Assert.IsTrue( _testReadyDivBase.IsValid, "There are still broken rules!  Count = " + tempDivBase.BrokenRulesCount.ToString() );
		}


		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void IsValid_Fail() {}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			BOL.DivisionBase tempDivBase = (DivisionBase)DivisionBase.GetBaseInfoForAllVbecsDivisions()[0];
			tempDivBase.SetInitialBrokenRules( "Division", "BaseRuleSet", true );
			//
			DataTable dtDiv = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM VamcDivision WHERE DivisionCode = '" + this.TestDivisionCode + "'");
			DataRow drTest = tempDivBase.LoadDataRowFromThis(dtDiv.Rows[0]);
			Assert.AreEqual(this._testReadyDivBase.DivisionCode.Trim(), drTest[TABLES.VamcDivision.DivisionCode].ToString().Trim(), "DivisionCode");
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void LoadDataRowFromThis_Fail()
		{
			DataTable dtDiv = UnitTestUtil.RunSQLGetDataTable("SELECT DivisionCode FROM VamcDivision WHERE DivisionCode = '" + this.TestDivisionCode + "'");
			DataRow drTest = this._testReadyDivBase.LoadDataRowFromThis(dtDiv.NewRow());
		}

		[Test]
		public void RefreshFromDb_Pass()
		{
			System.Guid testguid=System.Guid.NewGuid();

			this._testReadyDivBase.FacilityGuid=testguid;

			this._testReadyDivBase.RefreshFromDb();

			Assert.IsNotNull(this._testReadyDivBase);
			Assert.IsTrue(this._testReadyDivBase.FacilityGuid!=testguid);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions ) ]
		public void RefreshFromDb_Fail()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ParameterlessMethod)]
		public void Persist_Pass()
		{
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions ) ]
		public void Persist_Fail()
		{
		}

		[Test]
		public void FacilityGuid_Pass()
		{
			System.Guid testguid=System.Guid.NewGuid();
			System.Guid oldguid=this._testReadyDivBase.FacilityGuid;

			this._testReadyDivBase.FacilityGuid=testguid;

			Assert.IsTrue(this._testReadyDivBase.FacilityGuid!=oldguid);
		}

		[Test]
		public void FacilityGuid_Fail()
		{
			BOL.DivisionBase tmpBase=(DivisionBase)DivisionBase.GetBaseInfoForAllVbecsDivisions()[0];

			tmpBase.FacilityGuid=tmpBase.FacilityGuid;

			Assert.IsTrue(!this._testReadyDivBase.IsDirty);
		}

		[Test]
		public void AccessionAreaId_Pass()
		{
			int testid=this._testReadyDivBase.AccessionAreaId+1;
			int oldid=this._testReadyDivBase.AccessionAreaId;

			this._testReadyDivBase.AccessionAreaId=testid;

			Assert.IsTrue(this._testReadyDivBase.AccessionAreaId!=oldid);
		}

		[Test]
		public void AccessionAreaId_Fail()
		{
			BOL.DivisionBase tmpBase=(DivisionBase)DivisionBase.GetBaseInfoForAllVbecsDivisions()[0];

			tmpBase.AccessionAreaId=tmpBase.AccessionAreaId;

			Assert.IsTrue(!this._testReadyDivBase.IsDirty);
		}

		[Test]
		public void ServiceType_Pass()
		{
			Assert.IsNotNull(this._testReadyDivBase.ServiceType);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ServiceType_Fail()
		{
		}

		[Test]
		public void IsInactivatePending_Pass()
		{
			Assert.IsNotNull(this._testReadyDivBase.IsInactivationPending);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void IsInactivatePending_Fail()
		{
		}

		[Test]
		public void IsNew_Pass()
		{
			bool old=this._testReadyDivBase.IsNew;
			bool nw=!this._testReadyDivBase.IsNew;

			this._testReadyDivBase.IsNew=nw;

			Assert.IsTrue(this._testReadyDivBase.IsNew!=old);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ParameterlessMethod)]
		public void IsNew_Fail()
		{	
		}

		[Test]
		public void IsDirty_Pass()
		{
			BOL.DivisionBase tmpBase= (DivisionBase)DivisionBase.GetBaseInfoForAllVbecsDivisions()[0];

			tmpBase.AccessionAreaId = tmpBase.AccessionAreaId+1;

			Assert.IsTrue(tmpBase.IsDirty);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsDirty_LabelPrinterConfig_Pass()
		{	
			BOL.DivisionBase tmpBase = (DivisionBase)DivisionBase.GetBaseInfoForAllVbecsDivisions()[0];

			tmpBase.LabelPrinterConfig.Comments="TEST";

			Assert.IsTrue(tmpBase.LabelPrinterConfig.IsDirty);
			Assert.IsTrue(tmpBase.IsDirty);
		}

		[Test]
		public void IsDrty_TimeZoneConfig_Pass()
		{
			BOL.DivisionBase tmpBase = (DivisionBase)DivisionBase.GetBaseInfoForAllVbecsDivisions()[0];

			if (tmpBase.TimeZoneConfig.DaylightSavingsType==Common.DaylightSavingsType.Custom)
			{
				tmpBase.TimeZoneConfig.DaylightSavingsType=Common.DaylightSavingsType.DoNotObserve;
			}
			else
			{
				tmpBase.TimeZoneConfig.DaylightSavingsType=Common.DaylightSavingsType.Custom;
			}

			Assert.AreEqual(true,tmpBase.IsDirty,"IsDirty");
		}

		[Test]
		public void IsDirty_Fail()
		{	
			BOL.DivisionBase tmpBase= (DivisionBase)DivisionBase.GetBaseInfoForAllVbecsDivisions()[0];

			tmpBase.AccessionAreaId = tmpBase.AccessionAreaId;

			Assert.IsTrue(!tmpBase.IsDirty);
		}

		[Test]
		public void GetBrokenRulesMessage_Pass()
		{
			this._testReadyDivBase.SetInitialBrokenRules(BROKEN.FormClassName, BROKEN.RuleSets.BaseRuleSet, true);
			string tstValue = this._testReadyDivBase.GetBrokenRulesMessage(BROKEN.FormClassName);

			Assert.AreEqual(string.Empty, tstValue);		//Intially, no rules are broken
		}

		[Test]
		public void GetBrokenRulesMessage_Fail()
		{	
			string tstValue = this._testReadyDivBase.GetBrokenRulesMessage(Common.VbecsBrokenRules.FrmModifyUnits.FormClassName);

			Assert.AreEqual(string.Empty, tstValue);
		}

		[Test]
		public void IsBloodUnitNotInFinalStatus_Pass()
		{
			Assert.IsNotNull( this._testReadyDivBase.IsBloodUnitNotInFinalStatus() );
			Assert.AreEqual( true, this._testReadyDivBase.IsBloodUnitNotInFinalStatus() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void IsBloodUnitNotInFinalStatus_Fail()
		{
		}

		[Test]
		public void DivisionGuid_Pass()
		{
			Assert.IsNotNull( this._testReadyDivBase.DivisionGuid );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void DivisionGuid_Fail()
		{
		}

		[Test]
		public void Ctor_DivisionDefinitioin_Pass()
		{
			BOL.DivisionDefinition divDef=new DivisionDefinition( UnitTestConfig.TestDivisionCode, UnitTestConfig.TestDivisionName );
			BOL.DivisionBase divBase=new DivisionBase(divDef);

			Assert.IsNotNull(divBase);
			Assert.AreEqual(divDef.DivisionCode, divBase.DivisionCode);
			Assert.AreEqual(divDef.DivisionName, divBase.DivisionName);
		}

		[Test]
		[ExpectedException(typeof(BOL.BusinessObjectException))]
		public void Ctor_DivisionDefinitioin_Fail1()
		{	
			BOL.DivisionDefinition divDef=new DivisionDefinition( UnitTestConfig.TestDivisionCode, String.Empty );
			BOL.DivisionBase divBase=new DivisionBase(divDef);

			Assert.IsNotNull(divBase);
			Assert.AreEqual(divDef.DivisionCode, divBase.DivisionCode);
			Assert.AreEqual(divDef.DivisionName, divBase.DivisionName);
		}

		[Test]
		[ExpectedException(typeof(BOL.BusinessObjectException))]
		public void Ctor_DivisionDefinitioin_Fail2()
		{	
			BOL.DivisionDefinition divDef=new DivisionDefinition( String.Empty, UnitTestConfig.TestDivisionName );
			BOL.DivisionBase divBase=new DivisionBase(divDef);

			Assert.IsNotNull(divBase);
			Assert.AreEqual(divDef.DivisionCode, divBase.DivisionCode);
			Assert.AreEqual(divDef.DivisionName, divBase.DivisionName);
		}

		[Test]
		[ExpectedException(typeof(System.ArgumentNullException))]
		public void Ctor_DivisionDefinitioin_Fail3()
		{	
			BOL.DivisionDefinition divDef=new DivisionDefinition( UnitTestConfig.TestDivisionCode, null );
			BOL.DivisionBase divBase=new DivisionBase(divDef);

			Assert.IsNotNull(divBase);
			Assert.AreEqual(divDef.DivisionCode, divBase.DivisionCode);
			Assert.AreEqual(divDef.DivisionName, divBase.DivisionName);
		}

		[Test]
		[ExpectedException(typeof(System.ArgumentNullException))]
		public void Ctor_DivisionDefinitioin_Fail4()
		{	
			BOL.DivisionDefinition divDef=new DivisionDefinition( null, UnitTestConfig.TestDivisionName );
			BOL.DivisionBase divBase=new DivisionBase(divDef);

			Assert.IsNotNull(divBase);
			Assert.AreEqual(divDef.DivisionCode, divBase.DivisionCode);
			Assert.AreEqual(divDef.DivisionName, divBase.DivisionName);
		}

		[Test]
		public void CachedIsBloodUnitNotInFinalStatus_Pass()
		{
			Assert.IsNotNull( this._testReadyDivBase.CachedIsBloodUnitNotInFinalStatus() );
			Assert.AreEqual( true, this._testReadyDivBase.CachedIsBloodUnitNotInFinalStatus() );

		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void CachedIsBloodUnitNotInFinalStatus_Fail()
		{
		}
	}	
}
#endif
